TITLE   'Glass Block in a Parallel Field, Simplified'	         { 3d225a.pde }
SELECT     errlim=1e-4     ngrid=1     spectral_colors	
COORDINATES   cartesian3				{ Professional Edition }
VARIABLES   U
DEFINITIONS
   L=1.0     Lx=0.1     Ly=0.05     Lz=0.03
   eps0=8.854e-12
   epsr=1.0     eps=epsr*eps0
   E0=1.0     De0=eps0*E0	  			{ Far field }
   E=-grad(U)     Em=magnitude(E)     D=eps*E     Dm=magnitude(D)
EQUATIONS
   div( D)=0						
EXTRUSION						{ Parallel surfaces }
   surface 'bottom' z=-L	
   layer 'air 1'	 					{ Layer below block }
   surface 'lower' z=-Lz					{ Lower face of block }
   layer 'glass'						{ Containing glass }	
   surface 'upper' z=Lz					{ Upper face of block }
   layer 'air 2'						{ Layer above block }
   surface 'top' z=L
BOUNDARIES
   surface 'bottom'  natural( U)=De0		{ Since D=-eps*grad(U) }
   surface 'top'  natural( U)=-De0	
region 'domain'    					{ Full solution domain }	
   start (-L,-L)   natural( U)=0   line to (L,-L)  to (L,L)  to (-L,L)  close
limited region 'block'					{ Redefine space}	
   layer 'glass'   epsr=7.0				{ Glass block }
   start (-Lx,-Ly) line to (Lx,-Ly) to (Lx,Ly) to (-Lx,Ly) close
PLOTS
   grid( x, y, z)
   contour( U) on x=0     contour( U) on y=0
   vector( E) norm on x=0
   vector( E) norm on x=0 zoom(-0.2,-0.2,  0.4,0.4)
   vector( D) norm on x=0 zoom(-0.2,-0.2,  0.4,0.4) report(De0)
END

